function [S,V] = SVCJEuler(Kappa,Theta,Sigmav,Rho,V0,lambda,mius,sigmas,RhoJ,miuv,r,T,S0,N,n)
    miubar = ( ( exp(mius + 0.5*(sigmas^2)) ) / (1 - RhoJ*miuv) ) - 1;
    V = V0.*ones(N,1); %Initialise variance vector
    S = S0.*ones(N,1); %Initialise price vector

    for i = 1:N %Simulate along each path
        %Simulate Poisson jumps:
        JumpTimes = PoissonProcess(lambda,T); %Jump times
        Times = [JumpTimes T]; %Jump times and maturity
        TimeDiffs = [Times(1) diff(Times)]; %Times between jumps
        NumJumps = length(JumpTimes); %Number of jumps
        JumpSizesV = [exprnd(miuv,1,NumJumps) 0]; %Jumps sizes in
        JumpSizesS = [lognrnd(mius + RhoJ * JumpSizesV(1:end-1),sigmas) 1];%Jumps sizes in stock price process
        TimeSteps = ceil((TimeDiffs/T)*n);%Divide n (time steps) among jump times
        dt = TimeDiffs ./ TimeSteps; %Time step length
        for j = 1:NumJumps+1
            for k = 1:TimeSteps(j) %Simulate diffusion part between jumps
                Zv = randn;
                Zs = Rho*Zv+sqrt(1-Rho^2).*randn;
                S(i) = S(i) + S(i)*(r - lambda*miubar)*dt(j) + S(i).*sqrt(max(V(i),0)).*Zs*sqrt(dt(j));
                V(i) = V(i)+Kappa.*(Theta-V(i)).*dt(j) + Sigmav.*sqrt(max(V(i),0)).*Zv*sqrt(dt(j));
            end
            S(i) = S(i) * JumpSizesS(j); %Include jump in stock price
            V(i) = V(i) + JumpSizesV(j); %Include jump in variance
        end
    end